/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Other/javascript.js to edit this template
 */
const pluginID = "app.postalpoint.printscan";
exports.id = pluginID;

exports.init = function () {
    global.apis.ui.addToolsPage(
            global.apis.getPluginFolder(pluginID) + "/page.f7",
            "Print and Fax",
            "printscantool",
            "Add print, scan, copy, and fax jobs to a sale.",
            "Print and Fax",
            "fa-regular fa-file"
            );

    // Sync pricing changes with the store database
    global.apis.eventbus.on("pluginSettingsSaved", async function (pluginid) {
        if (pluginid != pluginID) {
            return;
        }
        for (var i = 0; i < exports.config.length; i++) {
            const key = exports.config[i].key;
            const defVal = exports.config[i].defaultVal;
            await global.apis.storage.setDB(key, global.apis.settings.get(key, defVal));
        }
    });
};



exports.getPricing = async function (mode) {
    const modeKey = `${pluginID}.${mode}_prices`;
    for (var i = 0; i < exports.config.length; i++) {
        const key = exports.config[i].key;
        const defVal = exports.config[i].defaultVal;
        if (key != modeKey) {
            continue;
        }
        return await global.apis.storage.getDB(key, global.apis.settings.get(key, defVal));
    }
};

exports.parsePricingString = function (str) {
    var lines = str.split("\n");
    var chart = [];
    for (var i = 0; i < lines.length; i++) {
        var num = lines[i].split(":")[0].trim();
        if (num.toUpperCase() == "MIN") {
            var p = lines[i].split(":")[1].trim() * 1.0;
            var q = lines[i].split(":")[2].trim() * 1;
            chart.push({
                num: "MIN",
                each: p,
                min: q
            });
        } else {
            var n = num * 1.0;
            var p = lines[i].split(":")[1].trim() * 1.0;

            chart.push({
                num: n,
                each: p
            });
        }
    }
    return chart;
};

exports.config = [
    {
        type: "textarea",
        key: pluginID + ".print_bw_prices",
        defaultVal: `1: 0.50
10: 0.45
50: 0.40`,
        label: "Black/White Print Prices",
        placeholder: `1: 0.50
10: 0.45
50: 0.40`,
        text: "<b>Black/White Printing</b>: Enter the number of pages and the price per page, as \"[number]: [dollar amount]\". To set a minimum job price/quantity, have the first line be \"MIN: [money] : [count]\". This will result in the first [count] pages costing a flat fee of [money]."
    },
    {
        type: "textarea",
        key: pluginID + ".print_color_prices",
        defaultVal: `1: 0.75
10: 0.70
50: 0.65`,
        label: "Color Print Prices",
        placeholder: `1: 0.75
10: 0.70
50: 0.65`,
        text: "<b>Color Printing</b>"
    },
    {
        type: "textarea",
        key: pluginID + ".copy_bw_prices",
        defaultVal: `1: 0.50
10: 0.45
50: 0.40`,
        label: "Black/White Copy Prices",
        placeholder: `1: 0.50
10: 0.45
50: 0.40`,
        text: "<b>Black/White Copies</b>"
    },
    {
        type: "textarea",
        key: pluginID + ".copy_color_prices",
        defaultVal: `1: 0.75
10: 0.70
50: 0.65`,
        label: "Color Copy Prices",
        placeholder: `1: 0.75
10: 0.70
50: 0.65`,
        text: "<b>Color Copies</b>"
    },
    {
        type: "textarea",
        key: pluginID + ".scan_prices",
        defaultVal: `1: 0.25
10: 0.20
50: 0.15`,
        label: "Scanning Prices",
        placeholder: `1: 0.25
10: 0.20
50: 0.15`,
        text: "<b>Scanning</b>"
    },
    {
        type: "textarea",
        key: pluginID + ".fax_prices",
        defaultVal: `1: 0.50
10: 0.40
50: 0.30`,
        label: "Faxing Prices",
        placeholder: `1: 0.50
10: 0.40
50: 0.30`,
        text: "<b>Faxing</b>"
    },
    {
        type: "text",
        key: pluginID + ".print_taxrate",
        defaultVal: "0",
        label: "Printing Tax Rate %",
        placeholder: "0"
    },
    {
        type: "text",
        key: pluginID + ".scanfax_taxrate",
        defaultVal: "0",
        label: "Scan/Fax Tax Rate %",
        placeholder: "0"
    },
    {
        type: "text",
        key: pluginID + ".merchcategory",
        defaultVal: "Print/Scan/Fax",
        label: "Merchandise Category",
        placeholder: ""
    }
];